
String representations of URIs or URLs are prone to parsing and encoding errors which can lead to vulnerabilities. The `System.Uri`<br>class is a safe alternative and should be preferred. At minimum, an overload of the method taking a `System.Uri` as a parameter should be<br>provided in each class that contains a method with an apparent Uri passed as a `string`.

This rule raises issues when a method has a string parameter with a name containing "uri", "Uri", "urn", "Urn", "url" or "Url", and the type<br>doesn't declare a corresponding overload taking an `System.Uri` parameter instead.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
       public class MyClass
       {
    
          public void FetchResource(string uriString) { } // Noncompliant
       }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
       public class MyClass
       {
    
          public void FetchResource(string uriString)
          {
              FetchResource(new Uri(uriString));
          }
    
          public void FetchResource(Uri uri) { }
       }
    }

