
By default the storage type of an `enum` is `Int32`. In most cases it is not necessary to change this. In particular you will<br>not achieve any performance gain by using a smaller data type (e.g. `Byte`) and may limit future uses.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
        public enum Visibility : sbyte // Noncompliant
        {
            Visible = 0,
            Invisible = 1,
        }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
        public enum Visibility
        {
            Visible = 0,
            Invisible = 1,
        }
    }

