
Because serialization constructors allocate and initialize objects, security checks that are present on regular constructors must also be present<br>on a serialization constructor. Failure to do so would allow callers that could not otherwise create an instance to use the serialization constructor<br>to do this.

This rule raises an issue when a type implements the `System.Runtime.Serialization.ISerializable` interface, is not a delegate or<br>interface, is declared in an assembly that allows partially trusted callers and has a constructor that takes a<br>`System.Runtime.Serialization.SerializationInfo` object and a `System.Runtime.Serialization.StreamingContext` object which is<br>not secured by a security check, but one or more of the regular constructors in the type is secured.

## Noncompliant Code Example


    using System;
    using System.IO;
    using System.Runtime.Serialization;
    using System.Runtime.Serialization.Formatters.Binary;
    using System.Security;
    using System.Security.Permissions;
    
    [assembly: AllowPartiallyTrustedCallersAttribute()]
    namespace MyLibrary
    {
        [Serializable]
        public class Foo : ISerializable
        {
            private int n;
    
            [FileIOPermissionAttribute(SecurityAction.Demand, Unrestricted = true)]
            public Foo()
            {
               n = -1;
            }
    
            protected Foo(SerializationInfo info, StreamingContext context) // Noncompliant
            {
               n = (int)info.GetValue("n", typeof(int));
            }
    
            void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
            {
               info.AddValue("n", n);
            }
        }
    }


## Compliant Solution


    using System;
    using System.IO;
    using System.Runtime.Serialization;
    using System.Runtime.Serialization.Formatters.Binary;
    using System.Security;
    using System.Security.Permissions;
    
    [assembly: AllowPartiallyTrustedCallersAttribute()]
    namespace MyLibrary
    {
        [Serializable]
        public class Foo : ISerializable
        {
            private int n;
    
            [FileIOPermissionAttribute(SecurityAction.Demand, Unrestricted = true)]
            public Foo()
            {
               n = -1;
            }
    
            [FileIOPermissionAttribute(SecurityAction.Demand, Unrestricted = true)]
            protected Foo(SerializationInfo info, StreamingContext context)
            {
               n = (int)info.GetValue("n", typeof(int));
            }
    
            void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
            {
               info.AddValue("n", n);
            }
        }
    }


## See

- [OWASP Top 10 2017 Category A8](https://www.owasp.org/index.php/Top_10-2017_A8-Insecure_Deserialization) - Insecure Deserialization<br>

