
When generating cryptograpic keys (or key pairs), it is important to use a key length that provides enough entropy against brute-force attacks. For<br>the RSA algorithm the key should be at

least 2048 bits long.

This rule raises an issue when a RSA key-pair generator is initialized with too small a length parameter.

## Noncompliant Code Example


    using System;
    using System.Security.Cryptography;
    
    namespace MyLibrary
    {
        public class MyCryptoClass
        {
            static void Main()
            {
                RSACryptoServiceProvider RSA = new RSACryptoServiceProvider(1024); // Noncompliant
                // ...
            }
        }
    }


## Compliant Solution


    using System;
    using System.Security.Cryptography;
    
    namespace MyLibrary
    {
        public class MyCryptoClass
        {
            static void Main()
            {
                RSACryptoServiceProvider RSA = new RSACryptoServiceProvider(2048);
                // ...
            }
        }
    }


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [OWASP Top 10 2017 Category A9](https://www.owasp.org/index.php/Top_10-2017_A6-Security_Misconfiguration) - Security<br>  Misconfiguration
- [ANSSI RGSv2](https://www.ssi.gouv.fr/uploads/2014/11/RGS_v-2-0_B1.pdf) - Référentiel Général de Sécurité version 2
- [NIST FIPS 186-4](https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.186-4.pdf) - Digital Signature Standard (DSS)
- [MITRE, CWE-326](http://cwe.mitre.org/data/definitions/326.html) - Inadequate Encryption Strength
- Derived from FindSecBugs rule [BLOWFISH\_KEY\_SIZE](https://find-sec-bugs.github.io/bugs.htm#BLOWFISH_KEY_SIZE)
- Derived from FindSecBugs rule [RSA\_KEY\_SIZE](https://find-sec-bugs.github.io/bugs.htm#RSA_KEY_SIZE)

