
Encryption algorithms can be used with various modes. Some combinations are not secured:

- Electronic Codebook (ECB) mode: Under a given key, any given plaintext block always gets encrypted to the same ciphertext block. Thus, it does<br>  not hide data patterns well. In some senses, it doesn't provide serious message confidentiality, and it is not recommended for use in cryptographic<br>  protocols at all.
- Cipher Block Chaining (CBC) with PKCS#5 padding (or PKCS#7) is susceptible to padding oracle attacks. CBC + PKCS#7 can be used if combined with<br>  an authenticity check (HMAC-SHA256 for example) on the cipher text.


In both cases, Galois/Counter Mode (GCM) with no padding should be preferred. As the .NET framework doesn't provide this natively, the use of a<br>certified third party lib is recommended.

This rule raises an issue when any of the following CipherMode is detected: ECB, CBC, OFB, CFB, CTS.

## Noncompliant Code Example


    AesManaged aes = new AesManaged
    {
      KeySize = 128,
      BlockSize = 128,
      Mode = CipherMode.OFB, // Noncompliant
      Padding = PaddingMode.PKCS7
    };


## See

- [OWASP Top 10 2017 Category A6](https://www.owasp.org/index.php/Top_10-2017_A6-Security_Misconfiguration) - Security<br>  Misconfiguration
- [MITRE, CWE-327](http://cwe.mitre.org/data/definitions/327.html) - Use of a Broken or Risky Cryptographic Algorithm
- [CERT, MSC61-J.](https://www.securecoding.cert.org/confluence/x/VwAZAg) - Do not use insecure or weak cryptographic algorithms
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses
- [Recommendation for Block Cipher Modes of Operation](https://nvlpubs.nist.gov/nistpubs/Legacy/SP/nistspecialpublication800-38a.pdf)
- Derived from FindSecBugs rule [ECB\_MODE](https://find-sec-bugs.github.io/bugs.htm#ECB_MODE)
- Derived from FindSecBugs rule [PADDING\_ORACLE](https://find-sec-bugs.github.io/bugs.htm#PADDING_ORACLE)


## Deprecated

This rule is deprecated; use {rule:csharpsquid:S5542} instead.
