## Pin versions in pip.

### Problematic code:

```dockerfile
FROM python:3.4
RUN pip install django
RUN pip install https://github.com/Banno/carbon/tarball/0.9.x-fix-events-callback
```

### Correct code:

```dockerfile
FROM python:3.4
RUN pip install django==1.9
RUN pip install git+https://github.com/Banno/carbon@0.9.15
```
### Rationale:

https://docs.docker.com/engine/articles/dockerfile_best-practices/

> Version pinning forces the build to retrieve a particular version regardless of what’s in the cache. This technique can also reduce failures due to unanticipated changes in required packages.