## You need a space or linefeed between the function name and body.

### Problematic code:

```sh
function foo{
  echo "hello world"
}
```

### Correct code:

Prefer POSIX syntax:
```sh
foo() {
  echo "hello world"
}
```

Alternatively, add the missing space between function name and opening `{`:
```sh
#           v-- Here
function foo {
  echo "hello world"
}
```
### Rationale:

When using `function` keyword function definitions without `()`, a space is required between the function name and the opening `{`.

### Exceptions:

None.