//#Patterns: Custom_Scala_HardCodedPassword
package analysis.samples.scala

import spray.http._
import java.sql.DriverManager
import java.security.KeyStore
import com.twitter.finagle.exp.Mysql
import com.twitter.finagle.socks._
import com.twitter.finagle.http._
import com.twitter.finagle.client.Transporter._
import javax.security.auth.callback._
import javax.security.auth.kerberos._

class HardCodedPassword {

  private val password = "hardcoded"
  private val otherPassword = "hardcoded-22"

  BasicHttpCredentials(1, 2)
  DriverManager.getConnection(1, 2, 3)

  //#Warn: Custom_Scala_HardCodedPassword
  BasicHttpCredentials(1, "hardcoded-20")
  //#Warn: Custom_Scala_HardCodedPassword
  BasicHttpCredentials(1, password)
  //#Warn: Custom_Scala_HardCodedPassword  
  BasicHttpCredentials(username=1, password="hardcoded-22")
  //#Warn: Custom_Scala_HardCodedPassword
  DriverManager.getConnection("a", "b-24", "c")
  //#Warn: Custom_Scala_HardCodedPassword
  new KeyStore.PasswordProtection("a-26".toArray)
  //#Warn: Custom_Scala_HardCodedPassword
  new KeyStore.PasswordProtection(Array('a'))
  //#Warn: Custom_Scala_HardCodedPassword
  Mysql.client.withCredentials("a", "30")
  //#Warn: Custom_Scala_HardCodedPassword
  UsernamePassAuthenticationSetting("a", "32")
  //#Warn: Custom_Scala_HardCodedPassword
  ProxyCredentials("a", "34")
  //#Warn: Custom_Scala_HardCodedPassword
  Credentials("a", "36")
  //#Warn: Custom_Scala_HardCodedPassword
  new PasswordCallback("a", false).setPassword("38".toCharArray)
  //#Warn: Custom_Scala_HardCodedPassword
  new KerberosKey(new KerberosPrincipal(realm), "40".toCharArray)
  //#Warn: Custom_Scala_HardCodedPassword
  new KerberosKey(new KerberosPrincipal(realm), password.toCharArray)
  

  def arguments(user: String, password: String, notHardCodedPassword: Something,
                passwordArray: Array[Char]) = {
    BasicHttpCredentials(user, notHardCodedPassword)

    BasicHttpCredentials(1, password)
    DriverManager.getConnection(user, password, notHardCodedPassword)
    new KeyStore.PasswordProtection(passwordArray)
    new PasswordCallback("a", false).setPassword(notHardCodedPassword.toCharArray)
  }

  def lookupClassLevel() = {
    //#Warn: Custom_Scala_HardCodedPassword
    BasicHttpCredentials(1, password)
    //#Warn: Custom_Scala_HardCodedPassword
    new KerberosKey(new KerberosPrincipal(realm), password.toCharArray)
  }

  def anonymousFunctionParam1() = {
    Option("").map(password => BasicHttpCredentials(1, password))
    Option("").map{ case bar => BasicHttpCredentials(1, password)}
    Option(("","")).map{ case bar@(password,t2) => BasicHttpCredentials(1, password)}
  }

  def anonymousFunctionParam2() = {
     //#Warn: Custom_Scala_HardCodedPassword
    Option("").map(password => BasicHttpCredentials(1, otherPassword))
  }

  def anonymousFunctionParam3() = {
     //#Warn: Custom_Scala_HardCodedPassword
     Option("").map{ case bar => BasicHttpCredentials(1, otherPassword)}
  }

  def anonymousFunctionParam4() = {
     //#Warn: Custom_Scala_HardCodedPassword
     Option(("","")).map{ case bar@(password,t2) => BasicHttpCredentials(1, otherPassword)}
  }

  val newPassword = "a"
  //#Warn: Custom_Scala_HardCodedPassword
  BasicHttpCredentials(1, newPassword)

}
