//#Patterns: Custom_Scala_HttpOnlyCookie
import spray.http._
import com.twitter.finagle.http._
import org.joda.time.{DateTimeZone, DateTime}

class Test {

   def something = false

   // Spray

   //#Warn: Custom_Scala_HttpOnlyCookie
   HttpCookie("a", "b")
   //#Warn: Custom_Scala_HttpOnlyCookie
   HttpCookie(name="a", content="b")
   //#Warn: Custom_Scala_HttpOnlyCookie
   HttpCookie("a", content="b")
   //#Warn: Custom_Scala_HttpOnlyCookie
   HttpCookie("a", "b", maxAge=Option(1L), domain=Option("test"))
   //#Warn: Custom_Scala_HttpOnlyCookie
   HttpCookie("a", "b", httpOnly = false)   
   //#Warn: Custom_Scala_HttpOnlyCookie
   HttpCookie("a", "b", Some(DateTime.now), Some(1), Some(""), Some(""), false, false)

   HttpCookie("a", "b", httpOnly = true)
   HttpCookie("a", "b", Some(DateTime.now), httpOnly = true)
   HttpCookie("a", "b", httpOnly = something)
   HttpCookie("a", "b", Some(DateTime.now), Some(1), Some(""), Some(""), false, true)

   f match {
     case HttpCookie(aaa, bbbb, cccc, dddd, d, p, s, h, e) => true
     case _ => false
   }

   // Finagle
   //#Warn: Custom_Scala_HttpOnlyCookie
   val finagleInsecureCookie = new Cookie("test", "test")
   //#Warn: Custom_Scala_HttpOnlyCookie
   val finagleInsecureCookie1 = new Cookie("test", "test")
   finagleInsecureCookie1.httpOnly = false

   val finagleSecureCookie = new Cookie("test", "test")
   finagleSecureCookie.httpOnly = true
   val potentialSecureCookie = new Cookie("test", "Test")
   potentialSecureCookie.httpOnly = something
   
   
}