# Remove space after = if trying to assign a value (or for empty string, use var='' ... ).

### Problematic code:

```sh
# I want programs to show text in dutch!
LANGUAGE= nl
```

```sh
# I want to run the nl command with English error messages!
LANGUAGE= nl
```

### Correct code:

```sh
# I want programs to show text in dutch!
LANGUAGE=nl
```

```sh
# I want to run the nl command with English error messages!
LANGUAGE='' nl
```

### Rationale:

It's easy to think that `LANGUAGE= nl` would assign `"nl"` to the variable `LANGUAGE`. It doesn't.

Instead, it runs `nl` (the "number lines" command) and sets `LANGUAGE` to an empty string in its environment.

Since trying to assign values this way is a common mistake, ShellCheck warns about it and asks you to be explicit when assigning empty strings (except for `IFS`, due to the common `IFS= read ..` idiom).

### Exceptions
If you're familiar with this behavior and feel that the explicit version is unnecessary, you can [[ignore]] it.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1007)

