##  This file has a UTF-8 BOM. Remove it with: LC_CTYPE=C sed '1s/^...//' < yourscript .

### Problematic code:

This is an encoding error that can't be seen in the script itself, but `cat -v` will show three bytes of garbage at the start of the file:

```
$ cat -v file
M-oM-;M-?#!/bin/bash
echo "hello world"
```

### Correct code:

The code is correct when this garbage does not appear.

### Rationale:

Some editors may save a file with a [Byte Order Mark](https://en.wikipedia.org/wiki/Byte_order_mark) to mark the file as UTF-8. Shells do not understand this and will give errors on the first line:

```
$ bash myscript
myscript: line 1: #!/bin/sh: No such file or directory

$ dash myscript
myscript: 1: myscript: #!/bin/sh: not found
```

To fix it, remove the byte order mark. One way of doing this is `LC_CTYPE=C sed '1s/^...//' < yourscript`. Verify that it's not there with `cat -v`. 

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC1082)

