## You need a space before the :.

### Problematic code:

```sh
until make
do:; done
```

### Correct code:

```sh
until make
do :; done
```
### Rationale:

ShellCheck found a keyword immediately followed by a `:`. `:` is a synonym for `true`, the command that "does nothing, successfully", and as a command name it needs a space. 

`do:` is as invalid as `dotrue`. Use `do :`, or preferably, `do true` for readability.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC1130)

