## #!/bin/sh was specified, so ____ is not supported, even when sh is actually bash.

The shebang indicates that the script works with `/bin/sh`, but you are using non-standard features that may not work with `/bin/sh`, **even if /bin/sh is actually bash**. Bash behaves differently when invoked as `sh`, and disabling support for the highlighted feature is one part of that.

Specify `#!/usr/bin/env bash` to ensure that bash (or your shell of choice) will be used, or rewrite the script to be more portable.

The Ubuntu wiki has [a list of portability issues](https://wiki.ubuntu.com/DashAsBinSh) and suggestions on how to rewrite them.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2040)

