## Since you double quoted this, it will not word split, and the loop will only run once.

### Problematic code:

```sh
for s in "$(mycommand)"; do echo "$s"; done
```

### Correct code:

The correct code depends on your intention. Let's say you're in a directory with the files `file.png` and `My cat.png`, and you want to loop over a command that outputs (or variable that contains):

```sh
hello world
My *.png
```

#### Loop over each line without globbing (`hello world`, `My *.png`)

```sh
mycommand | while IFS= read -r s; do echo "$s"; done
```

#### Loop over each word with globbing (`hello`, `world`, `My`, `file.png`, `My cat.png`):

```sh
# relies on the fact that IFS by default contains space-tab-linefeed
for s in $(mycommand); do echo "$s"; done
```

#### Loop over each line with globbing (`hello world`, `My cat.png`)

```sh
# explicitly set IFS to contain only a line feed
IFS='
'
for s in $(mycommand); do echo "$s"; done
```

### Rationale:

You get this warning because you have a loop that will only ever run exactly one iteration. Since you have a loop, you clearly expect it to run more than once. You just have to decide how it should be split up.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2066)

