## > is for string comparisons. Use -gt instead.

### Problematic code:

```sh
if [[ $var > 10 ]]
then
  echo "Incorrectly triggers when var=5"
fi
```

### Correct code:

```sh
if [[ $var -gt 10 ]]
then
  echo "Correct numerical comparison"
fi
```
### Rationale:

`<` and `>`, in both `[[` and `[` (when escaped) will do a lexicographical comparison, not a numerical comparison. 

This means that `[[ 5 > 10 ]]` is true because 5 comes after 10 alphabetically. Meanwhile `[[ 5 -gt 10 ]]` is false because 5 does not come after 10 numerically.

If you want to compare numbers by value, use the numerical comparison operators `-gt`, `-ge`, `-lt` and `-le`.

### Exceptions:

If the strings happen to be version numbers and you're using <, or > to compare them as strings, and you consider this an acceptable thing to do, then you can ignore this warning.

### Related resources:

* [Bash Pitfalls: `[[ $foo > 7 ]]`](https://mywiki.wooledge.org/BashPitfalls#pf7)
* [StackOverflow: Comparing numbers in Bash](https://stackoverflow.com/questions/18668556/comparing-numbers-in-bash)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2071)

