## Decimals are not supported. Either use integers only, or use bc or awk to compare.

### Problematic code:

```sh
[[ 2 -lt 3.14 ]]
```

### Correct code:

```sh
[[ 200 -lt 314 ]]                   # Use fixed point math
[[ $(echo "2 &lt; 3.14" | bc) == 1 ]]  # Use bc
```

### Rationale:

Bash and Posix sh does not support decimals in numbers. Decimals should either be avoided, or compared using a tool that does support them.

### Exceptions

If the strings happen to be version numbers and you're using `<`, or `>` to compare them as strings, and you consider this an acceptable thing to do, then you can ignore this warning.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2072)

