## Escape `\<` to prevent it redirecting (or switch to `[[ .. ]]`).

### Problematic code:

```sh
if [ "aardvark" < "zebra" ]
then
  echo "Alphabetical!"
fi
```

### Correct code:

```sh
if [ "aardvark" \< "zebra" ]
then
  echo "Alphabetical!"
fi
```

or optionally in Bash/Ksh:

```sh
if [[ "aardvark" < "zebra" ]]
then
  echo "Alphabetical!"
fi
```
### Rationale:

You are using the operator `<` or `>` in a `[` test expression.

In this context, it will be considered a file redirection operator instead, so `[ "aardvark" < "zebra" ]` is equivalent to `[ "aardvark" ] < ./zebra`, which is true if there exists a readable file `zebra` in the current directory.

If you wanted to compare two strings lexicographically (alphabetically), escape the `<` or `>` with a backslash as in the correct example. 

If you want to compare two numbers numerically, use `-lt` or `-ge` instead.

### Exceptions:

None.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2073)

