## This expression is constant. Did you forget a `$` somewhere?
### Problematic code:

```sh
if [ "myvar" ]
then
  echo "myvar is set"
fi
```

### Correct code:

```sh
if [ "$myvar" ]
then
  echo "myvar is set"
fi
```
### Rationale:

ShellCheck has found a `[ .. ]` or `[[ .. ]]` statement that just contains a literal string. Such a check does not do anything useful, and will always be true (or always false, for empty strings).

This is usually due to missing `$` or bad quoting:

    if [[ STY ]             # always true
    if [[ $STY ]]           # checks variable $STY

    if [[ 'grep foo bar' ]] # always true
    if [[ `grep foo bar` ]] # checks grep output (poorly)
    if grep -q foo bar      # checks for grep match (preferred)


### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC2078)

