# SC2094 Make sure not to read and write the same file in the same pipeline.

### Problematic code:

```sh
grep foo file.txt | sed -e 's/foo/bar/g' > file.txt
```

### Correct code:

```sh
grep foo file.txt  | sed -e 's/foo/bar/g' > tmpfile && mv tmpfile file.txt
```

### Rationale:

Each step in a pipeline runs in parallel.

In this case, `grep foo file.txt` will immediately try to read `file.txt` while `sed .. > file.txt` will immediately try to truncate it.

This is a race condition, and results in the file being partially or (far more likely) entirely truncated.

### Exceptions

You can ignore this error if:

* The file is a device or named pipe. These files don't truncate in the same way.
* The command mentions the filename but doesn't read/write it, such as `echo log.txt > log.txt`.

### Additional Resources

* [StackOverflow: bash redirect input from file back into same file](https://stackoverflow.com/questions/6696842/bash-redirect-input-from-file-back-into-same-file)
* [BashPitfalls: `cat file | sed s/foo/bar/ > file`](https://mywiki.wooledge.org/BashPitfalls#pf13)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2094)

