## Use `$((..))` for arithmetics, e.g. `i=$((i + 2))`

### Problematic code:

```sh
i=3
i=i+2
```

### Correct code:

```sh
i=3
i=$((i + 2))
```

### Rationale:

Unlike most languages, variable assignments (almost) always assigns strings and not expressions. In the example code, `i` will become the string `i+2` instead of the intended `5`. 

To instead evaluate a mathematical expressions, use `$((..))` as in the correct code.

### Exceptions:

If you wanted to assign a literal string, quote it:

    description="friendly-looking"

ShellCheck (as of v0.5) doesn't recognize Bash/Ksh numeric variables created with `declare -i` where this syntax is valid. Using `$((..))` still works, but you can also [[ignore]] this warning.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2100)

