## Instead of [ a || b ], use [ a ] || [ b ].

### Problematic code:

```sh
[ "$1" = "-v" || "$1" = "-help" ]
```

### Correct code:

```sh
[ "$1" = "-v" ] || [ "$1" = "-help" ]
```

### Rationale:

`||` can not be used in a `[ .. ]` test expression. Instead, make two `[ .. ]` expressions and put the `||` between them.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2109)

