## This format string has 2 variables, but is passed 1 arguments.

### Problematic code:

```sh
printf "Hello %s, welcome to %s.\n" "$USER"
```

### Correct code:

```sh
printf "Hello %s, welcome to %s.\n" "$USER" "$HOSTNAME"
```
### Rationale:

ShellCheck has noticed that you're using a `printf` format string with more `%s` variables than arguments to fill them.

In the problematic example case, the last `%s` will just become an empty string every time.

Either remove the unused variables from the format string, or add enough arguments to fill them.

### Exceptions:

When using the Ksh/Bash `%T` timestamp extension, such as `printf 'The time is %(%H:%M)T\n'`, an argument of `-1` and no argument are both taken to mean the current time. In these cases, consider specifying `-1` explicitly.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2183)

