## This does not read 'foo'. Remove $/${} for that, or use ${var?} to quiet.

### Problematic code:

```sh
read $foo
```

### Correct code:

```sh
read foo
```

### Rationale:

`read` takes a variable name, but shellcheck has noticed that you give it an expanded variable instead. This will populate whatever the variable expans to instead of the variable itself. For example:

    foo=bar
    read $foo   # Reads data into 'bar', not into 'foo'
    read foo    # Reads data into 'foo'

### Exceptions:

If this is intentional and you do want to read a variable through an indirect reference, you can silence this warning with a directive:

```sh
# shellcheck disable=SC2229
read "$foo"
```

Or take advantage of the fact that ShellCheck only warns when no parameter expansion modifiers are applied:

```sh
read "${foo}"    # ShellCheck warns
read "${foo?}"   # No warning
```

`${foo?}` fails when `foo` is unset, which is fine since `read` would have failed too. The main side effect is an improved runtime error message in that case.

### Related resources:

* [Bash Pitfalls #12](https://mywiki.wooledge.org/BashPitfalls#pf12): `read $foo`
[Source](https://github.com/koalaman/shellcheck/wiki/SC2229)

