## The exit status can only be one integer 0-255. Use stdout for other data.

### Problematic code:

```sh
exit foo bar
```

### Correct code:

```sh
echo foo
echo bar
exit
```

### Rationale:

In bash, `exit` can only be used to signal success or failure (0 = success, 1-255 = failure).

To exit with textual or multiple values from a function, write them to stdout and capture them with command substitution instead.

See [[SC2242]] for more information.

### Exceptions:

None

[Source](https://github.com/koalaman/shellcheck/wiki/SC2241)

