
When logging a message there are several important requirements which must be fulfilled:

- The user must be able to easily retrieve the logs
- The format of all logged message must be uniform to allow the user to easily read the log
- Logged data must actually be recorded
- Sensitive data must only be logged securely


If a program directly writes to the standard outputs, there is absolutely no way to comply with those requirements. That's why defining and using a dedicated logger is highly recommended.

## Noncompliant Code Example


    private void DoSomething()
    {
        // ...
        Console.WriteLine("so far, so good..."); // Noncompliant
        // ...
    }


## Exceptions

The following are ignored by this rule:

- Console Applications
- Calls in methods decorated with `[Conditional ("DEBUG")]`
- Calls included in DEBUG preprocessor branches (`#if DEBUG`)


## See

- [CERT, ERR02-J.](https://www.securecoding.cert.org/confluence/x/RoElAQ) - Prevent exceptions while logging data

