
Overriding or shadowing a variable declared in an outer scope can strongly impact the readability, and therefore the maintainability, of a piece of code. Further, it could lead maintainers to introduce bugs because they think they're using one variable but are really using another.

## Noncompliant Code Example


    class Foo
    {
      public int myField;
    
      public void DoSomething()
      {
        int myField = 0;  // Noncompliant
        ...
      }
    }


## See

- [CERT, DCL01-C.](https://wiki.sei.cmu.edu/confluence/display/c/DCL01-C.+Do+not+reuse+variable+names+in+subscopes) - Do not reuse<br>  variable names in subscopes
- [CERT, DCL51-J.](https://wiki.sei.cmu.edu/confluence/display/java/DCL51-J.+Do+not+shadow+or+obscure+identifiers+in+subscopes) - Do<br>  not shadow or obscure identifiers in subscopes

