
Utility classes, which are collections of `static` members, are not meant to be instantiated.

C# adds an implicit public constructor to every class which does not explicitly define at least one constructor. Hence, at least one `protected` constructor should be defined if you wish to subclass this utility class. Or the `static` keyword should be added to the class declaration to prevent subclassing.

## Noncompliant Code Example


    public class StringUtils // Noncompliant
    {
      public static string Concatenate(string s1, string s2)
      {
        return s1 + s2;
      }
    }


## Compliant Solution


    public static class StringUtils
    {
      public static string Concatenate(string s1, string s2)
      {
        return s1 + s2;
      }
    }


or


    public class StringUtils
    {
      protected StringUtils()
      {
      }
      public static string Concatenate(string s1, string s2)
      {
        return s1 + s2;
      }
    }

