
Throwing such general exceptions as `Exception`, `SystemException`, `ApplicationException`, `IndexOutOfRangeException`, `NullReferenceException`, `OutOfMemoryException` and `ExecutionEngineException` prevents calling methods from handling true, system-generated exceptions differently than application-generated errors.

## Noncompliant Code Example


    public void DoSomething(object obj)
    {
      if (obj == null)
      {
        throw new NullReferenceException("obj");  // Noncompliant
      }
      // ...
    }


## Compliant Solution


    public void DoSomething(object obj)
    {
      if (obj == null)
      {
        throw new ArgumentNullException("obj");
      }
      // ...
    }


## See

- [MITRE, CWE-397](http://cwe.mitre.org/data/definitions/397.html) - Declaration of Throws for Generic Exception
- [CERT, ERR07-J.](https://www.securecoding.cert.org/confluence/x/BoB3AQ) - Do not throw RuntimeException, Exception, or Throwable<br>

