
`private` or `internal` types or `private` members that are never executed or referenced are dead code: unnecessary, inoperative code that should be removed. Cleaning out dead code decreases the size of the maintained codebase, making it easier to understand the program and preventing bugs from being introduced.

## Noncompliant Code Example


    public class Foo
    {
        private void UnusedPrivateMethod() {...} // Noncompliant
    
        private class UnusedClass {...} // Noncompliant
    }


## Compliant Solution


    public class Foo
    {
        public Foo()
        {
            UsedPrivateMethod();
        }
    
        private void UsedPrivateMethod()
        {
            var c = new UsedClass();
        }
    
        private class UsedClass {...}
    }


## Exceptions

This rule doesn't raise issues on:

- Empty constructors
- Attributed members
- `Main` method
- Methods with event handler signature `void Foo(object, EventArgs)` that are declared in partial class
- Empty serialization constructor on type with `System.SerializableAttribute` attribute.
- Internals in assemblies that have a `System.Runtime.CompilerServices.InternalsVisibleToAttribute` attribute.

