
A `for` loop stop condition should test the loop counter against an invariant value (i.e. one that is true at both the beginning and ending of every loop iteration). Ideally, this means that the stop condition is set to a local variable just before the loop begins.

Stop conditions that are not invariant are slightly less efficient, as well as being difficult to understand and maintain, and likely lead to the introduction of errors in the future.

This rule tracks three types of non-invariant stop conditions:

- When the loop counters are updated in the body of the `for` loop
- When the stop condition depend upon a method call
- When the stop condition depends on an object property, since such properties could change during the execution of the loop.


## Noncompliant Code Example


    class Foo
    {
        static void Main()
        {
            for (int i = 1; i &lt;= 5; i++)
            {
                Console.WriteLine(i);
                if (condition)
                {
                   i = 20;
               }
            }
        }
    }


## Compliant Solution


    class Foo
    {
        static void Main()
        {
            for (int i = 1; i &lt;= 5; i++)
            {
                Console.WriteLine(i);
            }
        }
    }

