
`switch` statements and expressions are useful when there are many different cases depending on the value of the same expression.

When a `switch` statement or expression is simple enough, the code will be more readable with a single `if`, `if-else` or ternary conditional operator.

## Noncompliant Code Example


    switch (variable)
    {
      case 0:
        doSomething();
        break;
      default:
        doSomethingElse();
        break;
    }
    
    var foo = variable switch
    {
      0 =&gt; doSomething(),
      _ =&gt; doSomethingElse(),
    }


## Compliant Solution


    if (variable == 0)
    {
      doSomething();
    }
    else
    {
      doSomethingElse();
    }
    
    var foo = variable == 0
      ? doSomething()
      : doSomethingElse();

