
`NullReferenceException` should be avoided, not caught. Any situation in which `NullReferenceException` is explicitly caught can easily be converted to a `null` test, and any behavior being carried out in the catch block can easily be moved to the "is null" branch of the conditional.

## Noncompliant Code Example


    public int GetLengthPlusTwo(string str)
    {
        int length = 2;
        try
        {
           length += str.Length;
        }
        catch (NullReferenceException e)
        {
            log.info("argument was null");
        }
        return length;
    }


## Compliant Solution


    public int GetLengthPlusTwo(string str)
    {
        int length = 2;
    
        if (str != null)
        {
            length += str.Length;
        }
        else
        {
            log.info("argument was null");
        }
        return length;
    }


## See

- [MITRE, CWE-395](http://cwe.mitre.org/data/definitions/395.html) - Use of NullPointerException Catch to Detect NULL Pointer<br>  Dereference
- [CERT, ERR08-J.](https://www.securecoding.cert.org/confluence/x/BIB3AQ) - Do not catch NullPointerException or any of its ancestors<br>

