
A loop with at most one iteration is equivalent to the use of an `if` statement to conditionally execute one piece of code. If the initial intention of the author was really to conditionally execute one piece of code, an `if` statement should be used instead. If that was not the initial intention of the author, the body of the loop should be fixed to use the nested `return`, `break` or `throw` statements in a more appropriate way.

## Noncompliant Code Example


    for (int i = 0; i &lt; 10; i++)
    {
        Console.WriteLine(i);
        break;  // Noncompliant, loop only executes once
    }
    ...
    foreach (var item in items)
    {
        return item;  // Noncompliant, loop only executes once
    }
    ...


## Compliant Solution


    for (int i = 0; i &lt; 10; i++)
    {
        Console.WriteLine(i);
    }
    ...
    var item = items.FirstOrDefault();
    if (item != null)
    {
        return item;
    }
    ...

