
Using the same value on either side of a binary operator is almost always a mistake. In the case of logical operators, it is either a copy/paste error and therefore a bug, or it is simply wasted code, and should be simplified. In the case of bitwise operators and most binary mathematical operators, having the same value on both sides of an operator yields predictable results, and should be simplified.

## Noncompliant Code Example


    if ( a == a ) // always true
    {
      doZ();
    }
    if ( a != a ) // always false
    {
      doY();
    }
    if ( a == b &amp;&amp; a == b ) // if the first one is true, the second one is too
    {
      doX();
    }
    if ( a == b || a == b ) // if the first one is true, the second one is too
    {
      doW();
    }
    
    int j = 5 / 5; //always 1
    int k = 5 - 5; // always 0
    
    c.Equals(c);    //always true
    Object.Equals(c, c); //always true


## Exceptions

This rule ignores `*`, `+`, `=`, `<<`, and `>>`.

## See

- [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never<br>  executed
- {rule:csharpsquid:S1656} - Implements a check on `=`.

