
Having two `cases` in the same `switch` statement or branches in the same `if` structure with the same implementation is at best duplicate code, and at worst a coding error. If the same logic is truly needed for both instances, then in an `if` structure they should be combined, or for a `switch`, one should fall through to the other.

## Noncompliant Code Example


    switch (i)
    {
      case 1:
        DoFirst();
        DoSomething();
        break;
      case 2:
        DoSomethingDifferent();
        break;
      case 3:  // Noncompliant; duplicates case 1's implementation
        DoFirst();
        DoSomething();
        break;
      default:
        DoTheRest();
    }
    
    if (a &gt;= 0 &amp;&amp; a &lt; 10)
    {
      DoFirst();
      DoTheThing();
    }
    else if (a &gt;= 10 &amp;&amp; a &lt; 20)
    {
      DoTheOtherThing();
    }
    else if (a &gt;= 20 &amp;&amp; a &lt; 50)   // Noncompliant; duplicates first condition
    {
      DoFirst();
      DoTheThing();
    }


## Exceptions

Blocks in an `if` chain that contain a single line of code are ignored, as are blocks in a `switch` statement that contain a single line of code with or without a following `break`.


    if (a &gt;= 0 &amp;&amp; a &lt; 10)
    {
      DoTheThing();
    }
    else if (a &gt;= 10 &amp;&amp; a &lt; 20)
    {
      DoTheOtherThing();
    }
    else if (a &gt;= 20 &amp;&amp; a &lt; 50)    //no issue, usually this is done on purpose to increase the readability
    {
      DoTheThing();
    }


But this exception does not apply to `if` chains without `else`-s, or to `switch`-es without default clauses when all branches have the same single line of code. In case of `if` chains with `else`-s, or of `switch`-es with default clauses, rule {rule:csharpsquid:S3923} raises a bug.


    if(a == 1)
    {
      doSomething();  //Noncompliant, this might have been done on purpose but probably not
    }
    else if (a == 2)
    {
      doSomething();
    }

