
Type parameters that aren't used are dead code, which can only distract and possibly confuse developers during maintenance. Therefore, unused type parameters should be removed.

## Noncompliant Code Example


    public class MoreMath&lt;T&gt;   // Noncompliant; &lt;T&gt; is ignored
    {
      public int Add&lt;T&gt;(int a, int b) // Noncompliant; &lt;T&gt; is ignored
      {
        return a + b;
      }
    }


## Compliant Solution


    public class MoreMath
    {
      public int Add (int a, int b)
      {
        return a + b;
      }
    }

