
`GetHashCode` is used to file an object in a `Dictionary` or `Hashtable`. If `GetHashCode` uses non-`readonly` fields and those fields change after the object is stored, the object immediately becomes mis-filed in the `Hashtable`. Any subsequent test to see if the object is in the `Hashtable` will return a false negative.

## Noncompliant Code Example


    public class Person
    {
      public int age;
      public string name;
    
      public override int GetHashCode()
      {
        int hash = 12;
        hash += this.age.GetHashCode(); // Noncompliant
        hash += this.name.GetHashCode(); // Noncompliant
        return hash;
      }


## Compliant Solution


    public class Person
    {
      public readonly DateTime birthday;
      public string name;
    
      public override int GetHashCode()
      {
        int hash = 12;
        hash += this.birthday.GetHashCode();
        return hash;
      }

