
When constraints have not been applied to restrict a generic type parameter to be a reference type, then a value type, such as a `struct`, could also be passed. In such cases, comparing the type parameter to `null` would always be false, because a `struct` can be empty, but never `null`. If a value type is truly what's expected, then the comparison should use `default()`. If it's not, then constraints should be added so that no value type can be passed.

## Noncompliant Code Example


    private bool IsDefault&lt;T&gt;(T value)
    {
      if (value == null) // Noncompliant
      {
        // ...
      }
      // ...
    }


## Compliant Solution


    private bool IsDefault&lt;T&gt;(T value)
    {
      if(object.Equals(value, default(T)))
      {
        // ...
      }
      // ...
    }


or


    private bool IsDefault&lt;T&gt;(T value) where T : class
    {
      if (value == null)
      {
        // ...
      }
      // ...
    }

