
In property and indexer `set` methods, and in event `add` and `remove` methods, the implicit `value` parameter holds the value the accessor was called with. Not using the `value` means that the accessor ignores the caller's intent which could cause unexpected results at runtime.

## Noncompliant Code Example


    private int count;
    public int Count
    {
      get { return count; }
      set { count = 42; } // Noncompliant
    }


## Compliant Solution


    private int count;
    public int Count
    {
      get { return count; }
      set { count = value; }
    }


or


    public int Count
    {
      get { return count; }
      set { throw new InvalidOperationException(); }
    }


## Exceptions

This rule doesn't raise an issue when the setter is empty and part of the implementation of an `interface` . The assumption is that this part of the interface is not meaningful to that particular implementation. A good example of that would be a "sink" logger that discards any logs.
