
Marking a variable that is unchanged after initialization `const` is an indication to future maintainers that "no this isn't updated, and it's not supposed to be". `const` should be used in these situations in the interests of code clarity.

## Noncompliant Code Example


    public bool Seek(int[] input)
    {
      int target = 32;  // Noncompliant
      foreach (int i in input)
      {
        if (i == target)
        {
          return true;
        }
      }
      return false;
    }


## Compliant Solution


    public bool Seek(int[] input)
    {
      const int target = 32;
      foreach (int i in input)
      {
        if (i == target)
        {
          return true;
        }
      }
      return false;
    }

