
When a `static` constructor serves no other purpose that initializing `static` fields, it comes with an unnecessary performance cost because the compiler generates a check before each `static` method or instance constructor invocation.

Instead, inline initialization is highly recommended.

## Noncompliant Code Example


    namespace myLib
    {
      public class Foo
      {
        static int i;
        static string s;
    
        static Foo() // Noncompliant
        {
          i = 3;
          ResourceManager sm =  new ResourceManager("strings", Assembly.GetExecutingAssembly());
          s = sm.GetString("mystring");
        }
      }
    }


## Compliant Solution


    namespace myLib
    {
      public class Foo
      {
        static int i =3;
        static string s = InitString();
    
        static string InitString()
        {
          ResourceManager sm = new ResourceManager("strings", Assembly.GetExecutingAssembly());
          return sm.GetString("mystring");
        }
      }
    }

