
If an `enum` member's name contains the word "reserved" it implies it is not currently used and will be change in the future. However changing an `enum` member is a breaking change and can create significant problems. There is no need to reserve an `enum` member since a new member can be added in the future, and such an addition will usually not be a breaking change.

This rule raises an issue when the name of an enumeration member contains "reserved".

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
      public enum Color
      {
            None,
            Red,
            Orange,
            Yellow,
            ReservedColor  // Noncompliant
        }
    }

