
String literals embedded in the source code will not be localized properly.

This rule raises an issue when a literal string is passed as a parameter or property and one or more of the following cases is true:

- The `LocalizableAttribute` attribute of the parameter or property is set to true.
- The parameter or property name contains "Text", "Message", or "Caption".
- The name of the string parameter that is passed to a `Console.Write` or `Console.WriteLine` method is either "value" or<br>  "format".


## Noncompliant Code Example


    using System;
    using System.Globalization;
    using System.Reflection;
    using System.Windows.Forms;
    
    [assembly: NeutralResourcesLanguageAttribute("en-US")]
    namespace MyLibrary
    {
        public class Foo
        {
            public void SetHour(int hour)
            {
                if (hour &lt; 0 || hour &gt; 23)
                {
                    MessageBox.Show("The valid range is 0 - 23."); // Noncompliant
                }
            }
        }
    }


## Compliant Solution


    using System;
    using System.Globalization;
    using System.Reflection;
    using System.Resources;
    using System.Windows.Forms;
    
    
    
    [assembly: NeutralResourcesLanguageAttribute("en-US")]
    namespace MyLibrary
    {
        public class Foo
        {
            ResourceManager rm;
            public Foo()
            {
                rm = new ResourceManager("en-US", Assembly.GetExecutingAssembly());
            }
    
            public void SetHour(int hour)
            {
                if (hour &lt; 0 || hour &gt; 23)
                {
                    MessageBox.Show(
                    rm.GetString("OutOfRangeMessage", CultureInfo.CurrentUICulture));
                }
            }
        }
    }

