
When two methods have the same implementation, either it was a mistake - something else was intended - or the duplication was intentional, but may be confusing to maintainers. In the latter case, one implementation should invoke the other.

## Noncompliant Code Example


    private const string CODE = "bounteous";
    private int callCount = 0;
    
    public string GetCode()
    {
      callCount++;
      return CODE;
    }
    
    public string GetName()  // Noncompliant
    {
      callCount++;
      return CODE;
    }


## Compliant Solution


    private const string CODE = "bounteous";
    private int callCount = 0;
    
    public string GetCode()
    {
      callCount++;
      return CODE;
    }
    
    public string GetName()
    {
      return GetCode();
    }


## Exceptions

Empty methods, methods with only one line of code and methods with the same name (overload) are ignored.
