
When an assembly uses Windows Forms (classes and interfaces from the `System.Windows.Forms` namespace) its entry point should be marked with the `STAThreadAttribute` to indicate that the threading model should be "Single-Threaded Apartment" (STA) which is the only one supported by Windows Forms.

This rule raises an issue when the entry point (`static void Main` method) of an assembly using Windows Forms is not marked as STA.

## Noncompliant Code Example


    using System;
    using System.Windows.Forms;
    
    namespace MyLibrary
    {
        public class MyForm: Form
        {
            public MyForm()
            {
                this.Text = "Hello World!";
            }
    
            public static void Main()  // Noncompliant
            {
                var form = new MyForm();
                Application.Run(form);
            }
        }
    }


## Compliant Solution


    using System;
    using System.Windows.Forms;
    
    namespace MyLibrary
    {
        public class MyForm: Form
        {
            public MyForm()
            {
                this.Text = "Hello World!";
            }
    
            [STAThread]
            public static void Main()
            {
                var form = new MyForm();
                Application.Run(form);
            }
        }
    }

