
When creating a custom Markup Extension that accepts parameters in WPF, the `ConstructorArgument` markup must be used to identify the discrete properties that match these parameters. However since this is done via a string, the compiler will not notice if there are typos.

This rule raises an issue when the string argument to `ConstructorArgumentAttribute` doesn't match any parameter of any constructor.

## Noncompliant Code Example


    using System;
    
    namespace myLibrary
    {
      public class MyExtension : MarkupExtension
      {
        public MyExtension() { }
    
        public MyExtension(object value1)
        {
          Value1 = value1;
        }
    
        [ConstructorArgument("value2")]
        public object Value1 { get; set; }
      }
    }


## Compliant Solution


    using System;
    
    namespace myLibrary
    {
      public class MyExtension : MarkupExtension
      {
        public MyExtension() { }
    
        public MyExtension(object value1)
        {
          Value1 = value1;
        }
    
        [ConstructorArgument("value1")]
        public object Value1 { get; set; }
      }
    }

