
Delivering code in production with debug features activated is security-sensitive. It has led in the past to the following vulnerabilities:

- [CVE-2018-1999007](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-1999007)
- [CVE-2015-5306](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2015-5306)
- [CVE-2013-2006](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2013-2006)


An application's debug features enable developers to find bugs more easily and thus facilitate also the work of attackers. It often gives access to detailed information on both the system running the application and users.

## Ask Yourself Whether

- the code or configuration enabling the application debug features is deployed on production servers.
- the application runs by default with debug features activated.


You are at risk if you answered yes to any of these questions.

## Recommended Secure Coding Practices

Do not enable debug features on production servers.

The .Net Core framework offers multiple features which help during debug. `Microsoft.AspNetCore.Builder.IApplicationBuilder.UseDeveloperExceptionPage` and `Microsoft.AspNetCore.Builder.IApplicationBuilder.UseDatabaseErrorPage` are two of them. Make sure that those features are disabled in production.

Use `if (env.IsDevelopment())` to disable debug code.

## Sensitive Code Example

This rule raises issues when the following .Net Core methods are called: `Microsoft.AspNetCore.Builder.IApplicationBuilder.UseDeveloperExceptionPage`, `Microsoft.AspNetCore.Builder.IApplicationBuilder.UseDatabaseErrorPage`. No Issue is raised when those calls are disabled by `if
(env.IsDevelopment())`.


    using Microsoft.AspNetCore.Builder;
    using Microsoft.AspNetCore.Hosting;
    
    namespace mvcApp
    {
        public class Startup2
        {
            public void Configure(IApplicationBuilder app, IHostingEnvironment env)
            {
                if (env.IsDevelopment())
                {
                    // The following calls are ok because they are disabled in production
                    app.UseDeveloperExceptionPage();
                    app.UseDatabaseErrorPage();
                }
                // Those calls are Sensitive because it seems that they will run in production
                app.UseDeveloperExceptionPage(); // Sensitive
                app.UseDatabaseErrorPage(); // Sensitive
            }
        }
    }


## Exceptions

This rule does not analyze configuration files. Make sure that debug mode is not enabled by default in those files.

## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [MITRE, CWE-489](http://cwe.mitre.org/data/definitions/489.html) - Leftover Debug Code
- [MITRE, CWE-215](http://cwe.mitre.org/data/definitions/215.html) - Information Exposure Through Debug Information

