
Using upper case literal suffixes removes the potential ambiguity between "1" (digit 1) and "l" (letter el) for declaring literals.

## Noncompliant Code Example


    const long b = 0l;      // Noncompliant


## Compliant Solution


    const long b = 0L;


## See

- [CERT DCL16-C.](https://www.securecoding.cert.org/confluence/x/koAtAQ) - Use "L," not "l," to indicate a long value
- [CERT, DCL50-J.](https://www.securecoding.cert.org/confluence/x/hYClBg) - Use visually distinct identifiers

