/*
 * Decompiled with CFR 0.152.
 */
package codacy.foundation.api;

import codacy.foundation.api.FileContents;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.charset.CodingErrorAction;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.io.BufferedSource;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

public final class FileContents$
implements codacy.foundation.utils.Logger,
Serializable {
    public static final FileContents$ MODULE$;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new FileContents$();
    }

    private Logger logger$lzycompute() {
        FileContents$ fileContents$ = this;
        synchronized (fileContents$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public Option<FileContents> getContentsForFile(File ioFile) {
        return this.getLines(ioFile).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FileContents apply(Seq<String> contents) {
                return new FileContents(contents);
            }
        });
    }

    public Option<Seq<String>> getLines(File ioFile) {
        return this.getLines(ioFile.getAbsoluteFile().toString());
    }

    public Option<Seq<String>> getLines(String filename) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Codec codec = Codec$.MODULE$.apply("UTF-8");
        codec.onMalformedInput(CodingErrorAction.REPLACE);
        codec.onUnmappableCharacter(CodingErrorAction.REPLACE);
        Option res = Try$.MODULE$.apply((Function0)new Serializable(filename, codec){
            public static final long serialVersionUID = 0L;
            private final String filename$1;
            private final Codec codec$1;

            public final BufferedSource apply() {
                return Source$.MODULE$.fromFile(this.filename$1, this.codec$1);
            }
            {
                this.filename$1 = filename$1;
                this.codec$1 = codec$1;
            }
        }).toOption();
        if (res.isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Failed to open file: {}", new Object[]{filename});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Option sourceOpt = res;
        Option res2 = Try$.MODULE$.apply((Function0)new Serializable(sourceOpt){
            public static final long serialVersionUID = 0L;
            private final Option sourceOpt$1;

            public final Option<List<String>> apply() {
                return this.sourceOpt$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<String> apply(BufferedSource source) {
                        return source.getLines().toList();
                    }
                });
            }
            {
                this.sourceOpt$1 = sourceOpt$1;
            }
        }).toOption();
        sourceOpt.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(BufferedSource x$1) {
                x$1.close();
            }
        });
        if (res2.isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Failed to read file: {}", new Object[]{filename});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return res2.flatten(Predef$.MODULE$.$conforms());
    }

    public Seq<String> getLines(Seq<String> contents, int start, int end) {
        int nStart = start > end ? end : start;
        int nEnd = end < start ? start : end;
        int normalizedStart = Math.min(Math.max(nStart, 1) - 1, contents.length() - 1);
        int normalizedEnd = Math.max(1, Math.min(nEnd, contents.length()));
        return (Seq)contents.slice(normalizedStart, normalizedEnd);
    }

    public FileContents apply(Seq<String> contents) {
        return new FileContents(contents);
    }

    public Option<Seq<String>> unapply(FileContents x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.contents());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FileContents$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

