/*
 * Decompiled with CFR 0.152.
 */
package codacy.foundation.files;

import codacy.foundation.files.FileSystemProviderBase;
import codacy.foundation.files.FileSystemProviderBase$;
import codacy.foundation.files.IgnoreDirectoryFilter;
import codacy.foundation.files.SymlinkFilter;
import java.io.File;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.UUID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public abstract class FileSystemProviderBase$class {
    public static File randomTempDirectory(FileSystemProviderBase $this) {
        return Files.createTempDirectory(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"codacy-tmp-"})).s((Seq)Nil$.MODULE$), new FileAttribute[0]).toFile();
    }

    /*
     * WARNING - void declaration
     */
    public static Object withRandomFile(FileSystemProviderBase $this, Function1 block) {
        void var3_3;
        File randomFile = Files.createTempFile("codacy-", "", new FileAttribute[0]).toFile();
        Object result = block.apply((Object)randomFile);
        $this.removeTree(randomFile);
        return var3_3;
    }

    public static Seq listFiles(FileSystemProviderBase $this, File dir, IgnoreDirectoryFilter ignoreDirectoryFilter, SymlinkFilter symlinkFilter) {
        File[] files = FileSystemProviderBase$class.codacy$foundation$files$FileSystemProviderBase$$fetchFiles($this, dir, ignoreDirectoryFilter, symlinkFilter);
        String[] filePaths = (String[])Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable($this, dir){
            public static final long serialVersionUID = 0L;
            private final File dir$1;

            public final String apply(File x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1.getAbsolutePath())).stripPrefix(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$1.getAbsolutePath()})));
            }
            {
                this.dir$1 = dir$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return Predef$.MODULE$.wrapRefArray((Object[])filePaths);
    }

    public static IgnoreDirectoryFilter listFiles$default$2(FileSystemProviderBase $this) {
        return $this.codacy$foundation$files$FileSystemProviderBase$$defaultIgnoreDirectoryFilter();
    }

    public static SymlinkFilter listFiles$default$3(FileSystemProviderBase $this) {
        return $this.codacy$foundation$files$FileSystemProviderBase$$defaultSymlinkFilter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File[] codacy$foundation$files$FileSystemProviderBase$$fetchFiles(FileSystemProviderBase $this, File file, IgnoreDirectoryFilter ignoreDirectoryFilter, SymlinkFilter symlinkFilter) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = file.isDirectory();
        if (bl3) {
            bl = true;
            bl2 = bl3;
            if (Predef$.MODULE$.refArrayOps((Object[])file.list(ignoreDirectoryFilter)).nonEmpty()) {
                return (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class));
            }
        }
        if (!bl) return (File[])((Object[])new File[]{file});
        return (File[])Predef$.MODULE$.refArrayOps((Object[])file.listFiles(symlinkFilter)).flatMap((Function1)new Serializable($this, ignoreDirectoryFilter, symlinkFilter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemProviderBase $outer;
            private final IgnoreDirectoryFilter ignoreDirectoryFilter$1;
            private final SymlinkFilter symlinkFilter$1;

            public final ArrayOps<File> apply(File f) {
                return Predef$.MODULE$.refArrayOps((Object[])FileSystemProviderBase$class.codacy$foundation$files$FileSystemProviderBase$$fetchFiles(this.$outer, f, this.ignoreDirectoryFilter$1, this.symlinkFilter$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ignoreDirectoryFilter$1 = ignoreDirectoryFilter$1;
                this.symlinkFilter$1 = symlinkFilter$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    public static Try removeTree(FileSystemProviderBase $this, File file) {
        return Try$.MODULE$.apply((Function0)new Serializable($this, file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Path rootPath = Paths.get(this.file$1.getAbsolutePath(), new String[0]);
                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(rootPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).iterator()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final File apply(Path x$2) {
                        return x$2.toFile();
                    }
                }).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$3) {
                        return x$3.delete();
                    }
                });
            }
            {
                this.file$1 = file$1;
            }
        });
    }

    public static boolean onSameFilesystem(FileSystemProviderBase $this, Path path1, Path path2) {
        return path1.getFileSystem().equals(path2.getFileSystem());
    }

    public static Path atomicMove(FileSystemProviderBase $this, Path source, Path destination) {
        return Files.move(source, destination, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void removeDirectories(FileSystemProviderBase $this, Seq dirs) {
        File newPath = FileSystemProviderBase$.MODULE$.randomTempDirectory();
        try {
            Seq pathsToRemove = (Seq)((SeqLike)dirs.collect((PartialFunction)new Serializable($this, newPath){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemProviderBase $outer;
                private final File newPath$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final <A1 extends File, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Path path;
                    Path destPath;
                    Object object;
                    A1 A1 = x1;
                    if (!A1.exists()) {
                        object = function1.apply(x1);
                        return (B1)object;
                    }
                    Path dirPath = Paths.get(A1.getAbsolutePath(), new String[0]);
                    if (this.$outer.onSameFilesystem(dirPath, destPath = Paths.get(this.newPath$1.getAbsolutePath(), new String[0]))) {
                        try {
                            this.$outer.atomicMove(dirPath, destPath);
                            path = destPath;
                        }
                        catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
                            path = FileSystemProviderBase$class.renameInPlace$1(this.$outer, dirPath);
                        }
                    } else {
                        path = FileSystemProviderBase$class.renameInPlace$1(this.$outer, dirPath);
                    }
                    object = path;
                    return (B1)object;
                }

                public final boolean isDefinedAt(File x1) {
                    File file = x1;
                    boolean bl = file.exists();
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.newPath$1 = newPath$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).distinct();
            pathsToRemove.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemProviderBase $outer;

                public final void apply(Path path) {
                    Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, path){
                        public static final long serialVersionUID = 0L;
                        private final Path path$1;

                        public final Try<BoxedUnit> apply() {
                            return FileSystemProviderBase$.MODULE$.removeTree(this.path$1.toFile());
                        }
                        {
                            this.path$1 = path$1;
                        }
                    });
                    if (try_ instanceof Failure) {
                        BoxedUnit boxedUnit;
                        Failure failure = (Failure)try_;
                        Throwable error = failure.exception();
                        if (this.$outer.logger().underlying().isErrorEnabled()) {
                            this.$outer.logger().underlying().error("Error executing command: {}", error);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("Exception", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final Path renameInPlace$1(FileSystemProviderBase $this, Path source) {
        void var2_2;
        Path dest = source.resolveSibling(UUID.randomUUID().toString());
        Files.move(source, dest, new CopyOption[0]);
        return var2_2;
    }

    public static void $init$(FileSystemProviderBase $this) {
        $this.codacy$foundation$files$FileSystemProviderBase$_setter_$codacy$foundation$files$FileSystemProviderBase$$defaultIgnoreDirectoryFilter_$eq(new IgnoreDirectoryFilter());
        $this.codacy$foundation$files$FileSystemProviderBase$_setter_$codacy$foundation$files$FileSystemProviderBase$$defaultSymlinkFilter_$eq(new SymlinkFilter());
    }
}

